package review

import (
	"context"

	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetReviewDetailLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取复盘详情
func NewGetReviewDetailLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetReviewDetailLogic {
	return &GetReviewDetailLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetReviewDetailLogic) GetReviewDetail(req *types.IDReq) (resp *types.ReviewDetailResp, err error) {
	detailResp, err := l.svcCtx.KpiCenterRpc.DetailReview(l.ctx, &kpi_rpc.IDRequest{Id: req.ID})
	if err != nil {
		return nil, err
	}
	resp = &types.ReviewDetailResp{}
	err = copier.Copy(resp, &detailResp)
	resp.CreatedAt = detailResp.CreatedAt
	resp.UpdatedAt = detailResp.UpdatedAt
	return resp, err
}
