package review

import (
	"context"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetReviewListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取复盘列表
func NewGetReviewListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetReviewListLogic {
	return &GetReviewListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetReviewListLogic) GetReviewList(req *types.ReviewListReq) (resp *types.ReviewListResp, err error) {
	listResp, err := l.svcCtx.KpiCenterRpc.ListReview(l.ctx, &kpi_rpc.ListReviewRequest{
		Page:           req.Page,
		PageSize:       req.PageSize,
		Levels:         req.Levels,
		DepartmentKeys: req.DepartmentKeys,
		TeamKeys:       req.TeamKeys,
		Responsible:    req.Responsible,
		//Handler:        req.Handler,
		//IssueId:        req.IssueID,
		StartTime: req.StartTime,
		EndTime:   req.EndTime,
	})
	if err != nil {
		return nil, err
	}
	resp = &types.ReviewListResp{}
	err = copier.Copy(&resp, &listResp)
	return resp, err
}
