package review

import (
	"context"
	"git.lbk.world/test/devops/lbk-go-sdk/usercenter"
	"github.com/zeromicro/go-zero/core/logx"
	"oa-server/app/kpicenter/kpi_api/internal/svc"
	"oa-server/app/kpicenter/kpi_api/internal/types"
	"oa-server/common/globalkey"
)

type GetDepartmentsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

// 获取可填写的部门和组
func NewGetDepartmentsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetDepartmentsLogic {
	return &GetDepartmentsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetDepartmentsLogic) GetDepartments(req *types.GetDepartmentsHandlerReq) (resp *types.GetDepartmentsHandlerResp, err error) {
	publicUserDepartmentListWithChildrenReq := usercenter.PublicUserDepartmentListWithChildrenReq{
		AppTokenMustModel: usercenter.AppTokenMustModel{
			AppKey:   l.svcCtx.Config.LbkUsercenter.AppName,
			AppToken: l.svcCtx.Config.LbkUsercenter.AppToken,
		},
		Owner: globalkey.RockyEmail,
	}
	managedDepartments, err := l.svcCtx.LbkUcClient.GetDepartmentListWithChildren(l.ctx, publicUserDepartmentListWithChildrenReq)
	if err != nil {
		logx.Errorw("failed to call usercenter.GetDepartmentListWithChildren on GetReportStatistics", logx.Field("error", err))
		return nil, err
	}
	managedDepartmentToChildren := make(map[string]map[string]struct{})
	managedDepartmentToChildren5 := make(map[string]map[string]struct{})
	for _, department := range managedDepartments {
		if department.DepartmentLevel == 3 {
			managedDepartmentToChildren[department.DepartmentKey] = make(map[string]struct{})
		}
		if department.DepartmentLevel == 4 {
			managedDepartmentToChildren5[department.DepartmentKey] = make(map[string]struct{})
		}
	}
	for _, department := range managedDepartments {
		if department.DepartmentLevel == 4 {
			if _, ok := managedDepartmentToChildren[department.ParentDepartmentKey]; !ok {
				continue
			}
			managedDepartmentToChildren[department.ParentDepartmentKey][department.DepartmentKey] = struct{}{}
		}
		if department.DepartmentLevel == 5 {
			if _, ok := managedDepartmentToChildren5[department.ParentDepartmentKey]; !ok {
				continue
			}
			managedDepartmentToChildren5[department.ParentDepartmentKey][department.DepartmentKey] = struct{}{}
			//od-d1a42ad540f3613250ceaf11e705facc基础保障部-效能保障队	od-3641babed41031f38c9a451258317258基础保障部-效能保障队-工程效率组
		}
	}
	departmentsByKey := make(map[string]*usercenter.UserDepartmentOutside)
	for _, department := range managedDepartments {
		departmentsByKey[department.DepartmentKey] = department
	}

	resp = &types.GetDepartmentsHandlerResp{
		List: nil,
	}
	for departmentKey, childKeys := range managedDepartmentToChildren {
		respDepartment := &types.Department{
			Key:      departmentKey,
			Name:     departmentsByKey[departmentKey].DepartmentName,
			Children: nil,
		}
		for childKey := range childKeys {
			respTeam := &types.Department{
				Key:      childKey,
				Name:     departmentsByKey[childKey].DepartmentName,
				Children: nil,
			}
			//respTeam   "key": "od-d1a42ad540f3613250ceaf11e705facc",
			//	"name": "基础保障部-效能保障队",
			//	"child_departments": [
			for childKey5 := range managedDepartmentToChildren5[childKey] {
				respTeam.Children = append(respTeam.Children, &types.Department{
					Key:  childKey5,
					Name: departmentsByKey[childKey5].DepartmentName,
				})
			}
			respDepartment.Children = append(respDepartment.Children, respTeam)
		}
		resp.List = append(resp.List, respDepartment)
	}
	return resp, nil
}
