package svc

import (
	"oa-server/app/kpicenter/kpi_api/internal/config"
	"oa-server/app/kpicenter/kpi_rpc/kpirpcclient"
	"oa-server/common/middleware"

	lbkUc "git.lbk.world/test/devops/lbk-go-sdk/usercenter"

	"github.com/zeromicro/go-zero/rest"
	"github.com/zeromicro/go-zero/zrpc"
)

type ServiceContext struct {
	Config         config.Config
	LbkUcClient    *lbkUc.LbkUserClient
	AuthMiddleware rest.Middleware
	KpiCenterRpc   kpirpcclient.KpiRpc
}

func NewServiceContext(c config.Config) *ServiceContext {
	lbkUcClient, _ := lbkUc.NewLbkUserClient(c.LbkUsercenter.Env, c.LbkUsercenter.HostInAli)

	return &ServiceContext{
		Config:         c,
		LbkUcClient:    lbkUcClient,
		AuthMiddleware: middleware.NewAuthMiddleware(c.LbkUsercenter.AppName, lbkUcClient).Handle,
		KpiCenterRpc:   kpirpcclient.NewKpiRpc(zrpc.MustNewClient(c.KpiCenterRpcConf)),
	}
}
