package svc

import (
	"errors"
	"fmt"
	"time"
)

func CutDateStr(dateStr string) (string, string, error) {
	// 解析日期字符串
	t, err := time.Parse("2006-01", dateStr)
	if err != nil {
		return "", "", errors.New("invalid date format, must be 'yyyy-MM'")
	}

	year := t.Year()
	quarter := t.Month()
	if quarter > 4 {
		quarter = 4
	}

	// // 计算季度
	// var quarter int
	// switch {
	// case month >= 1 && month <= 3:
	// 	quarter = 1
	// case month >= 4 && month <= 6:
	// 	quarter = 2
	// case month >= 7 && month <= 9:
	// 	quarter = 3
	// case month >= 10 && month <= 12:
	// 	quarter = 4
	// }

	return fmt.Sprintf("%d", year), fmt.Sprintf("%d", quarter), nil
}
