package logic

import (
	"context"
	"fmt"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/app/kpicenter/model"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type AddReviewLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewAddReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AddReviewLogic {
	return &AddReviewLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *AddReviewLogic) AddReview(in *kpi_rpc.AddReviewRequest) (*kpi_rpc.Response, error) {
	data := &model.XReview{}
	err := copier.Copy(&data, in)
	if err != nil {
		fmt.Println(err)
		return nil, err
	}

	err = l.svcCtx.XReviewModel.InsertAndUser(l.ctx, data, in.Users)
	return &kpi_rpc.Response{}, err
}
