package logic

import (
	"context"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/app/kpicenter/model"

	"github.com/zeromicro/go-zero/core/logx"
)

type CreateOkrLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewCreateOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateOkrLogic {
	return &CreateOkrLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *CreateOkrLogic) CreateOkr(in *kpi_rpc.CreateOkrReq) (*kpi_rpc.SuccessResp, error) {
	data := &[]model.XOkr{}
	for _, v := range in.Data {
		*data = append(*data, model.XOkr{
			Creator:    in.Email,
			YearStr:    in.YearStr,
			QuarterStr: in.QuarterStr,
			Target:     v.Target,
			Result:     v.Result,
		})
	}

	err := l.svcCtx.XOkrModel.BatchInsert(l.ctx, data)
	if err != nil {
		return nil, err
	}

	return &kpi_rpc.SuccessResp{Success: true}, nil
}
