package logic

import (
	"context"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteOkrLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDeleteOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteOkrLogic {
	return &DeleteOkrLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DeleteOkrLogic) DeleteOkr(in *kpi_rpc.DelOkrReq) (*kpi_rpc.SuccessResp, error) {
	oID := in.Id
	email := in.Email

	err := l.svcCtx.XOkrModel.DelOkr(l.ctx, oID, email)
	if err != nil {
		return nil, err
	}
	return &kpi_rpc.SuccessResp{Success: true}, nil
}
