package logic

import (
	"context"
	"errors"
	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/zeromicro/go-zero/core/logx"
)

type DeleteReviewLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDeleteReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DeleteReviewLogic {
	return &DeleteReviewLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DeleteReviewLogic) DeleteReview(in *kpi_rpc.DeleteReviewReq) (*kpi_rpc.Response, error) {
	row, err := l.svcCtx.XReviewModel.FindOne(l.ctx, in.Id)
	if err != nil {
		return nil, err
	}
	if row.Owner != in.SignedInUser {
		return nil, errors.New("not allowed")
	}
	err = l.svcCtx.XReviewModel.Delete(l.ctx, in.Id)
	if err != nil {
		return nil, err
	}
	return &kpi_rpc.Response{}, err
}
