package logic

import (
	"context"
	"time"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type DetailReviewLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewDetailReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DetailReviewLogic {
	return &DetailReviewLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *DetailReviewLogic) DetailReview(in *kpi_rpc.IDRequest) (*kpi_rpc.DetailReviewResponse, error) {
	data, err := l.svcCtx.XReviewModel.FindOneAndUser(l.ctx, in.Id)
	if err != nil {
		return nil, err
	}
	res := &kpi_rpc.DetailReviewResponse{}
	copier.Copy(&res, data)
	res.CreatedAt = data.CreatedAt.Local().Format(time.DateTime)
	res.UpdatedAt = data.UpdatedAt.Local().Format(time.DateTime)
	return res, nil
}
