package logic

import (
	"context"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetOkrListLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewGetOkrListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetOkrListLogic {
	return &GetOkrListLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *GetOkrListLogic) GetOkrList(in *kpi_rpc.OkrListReq) (*kpi_rpc.OkrListResp, error) {
	resp := &kpi_rpc.OkrListResp{}
	total, list, err := l.svcCtx.XOkrModel.GetList(l.ctx, in.Page, in.PageSize, in.Email, in.YearStr, in.QuarterStr)
	if err != nil {
		return resp, err
	}
	for _, item := range list {
		r := &kpi_rpc.OkrDetailResp{}
		copier.Copy(&r, item)
		resp.List = append(resp.List, r)
	}
	resp.Total = total
	return resp, nil
}
