package logic

import (
	"context"
	"time"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type ListReviewLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewListReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListReviewLogic {
	return &ListReviewLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *ListReviewLogic) ListReview(in *kpi_rpc.ListReviewRequest) (*kpi_rpc.ListReviewResponse, error) {
	total, list, err := l.svcCtx.XReviewModel.GetList(l.ctx, in.Page, in.PageSize, in.Levels, in.DepartmentKeys, in.TeamKeys, in.Responsible, in.StartTime, in.EndTime)
	if err != nil {
		logx.WithContext(l.ctx).Errorf("ListReviewLogic.ListReview err: %v", err)
		return nil, err
	}
	res := &kpi_rpc.ListReviewResponse{}
	res.Total = total
	for _, item := range list {
		review := &kpi_rpc.DetailReviewResponse{}
		copier.Copy(&review, item)
		review.CreatedAt = item.CreatedAt.Format(time.DateTime)
		review.UpdatedAt = item.UpdatedAt.Format(time.DateTime)
		res.List = append(res.List, review)
	}

	return res, nil
}
