package logic

import (
	"context"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/app/kpicenter/model"

	"github.com/jinzhu/copier"
	"github.com/zeromicro/go-zero/core/logx"
)

type UpReviewLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpReviewLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpReviewLogic {
	return &UpReviewLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpReviewLogic) UpReview(in *kpi_rpc.UpReviewRequest) (*kpi_rpc.Response, error) {
	data := &model.XReview{}
	err := copier.Copy(data, in)
	if err != nil {
		return nil, err
	}
	err = l.svcCtx.XReviewModel.UpdateAndUser(l.ctx, data, in.Users)
	return &kpi_rpc.Response{}, err
}
