package logic

import (
	"context"

	"oa-server/app/kpicenter/kpi_rpc/internal/svc"
	"oa-server/app/kpicenter/kpi_rpc/pb/kpi_rpc"
	"oa-server/app/kpicenter/model"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateOkrLogic struct {
	ctx    context.Context
	svcCtx *svc.ServiceContext
	logx.Logger
}

func NewUpdateOkrLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateOkrLogic {
	return &UpdateOkrLogic{
		ctx:    ctx,
		svcCtx: svcCtx,
		Logger: logx.WithContext(ctx),
	}
}

func (l *UpdateOkrLogic) UpdateOkr(in *kpi_rpc.UpOkrReq) (*kpi_rpc.SuccessResp, error) {
	data := &model.XOkr{
		Creator:    in.Email,
		Id:         in.Id,
		Target:     in.Target,
		Result:     in.Result,
		YearStr:    in.YearStr,
		QuarterStr: in.QuarterStr,
	}

	_, err := l.svcCtx.XOkrModel.UpOkr(l.ctx, data)
	if err != nil {
		return nil, err
	}
	return &kpi_rpc.SuccessResp{Success: true}, nil
}
