package svc

import (
	"oa-server/app/kpicenter/kpi_rpc/internal/config"
	"oa-server/app/kpicenter/model"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

type ServiceContext struct {
	Config       config.Config
	XReviewModel model.XReviewModel
	// XReviewUser model.XReviewUserModel
	XOkrModel model.XOkrModel
}

func NewServiceContext(c config.Config) *ServiceContext {
	sqlConn := sqlx.NewMysql(c.DB.DataSource)
	return &ServiceContext{
		Config:       c,
		XReviewModel: model.NewXReviewModel(sqlConn),
		// XReviewUser: model.XReviewUserModel(sqlConn),
		XOkrModel: model.NewXOkrModel(sqlConn),
	}
}
