CREATE TABLE `x_review` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `level` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '故障定级',
  `issue_id` int unsigned NOT NULL COMMENT 'issue_id',
  `scope` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '影响范围',
  `review` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '回顾',
  `root_cause` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '故障根因',
  `scheme` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '修复方案',
  `improvement` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '改进方案',
  `kpi` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '关联绩效',
  `remark` text COLLATE utf8mb4_general_ci NOT NULL COMMENT '备注',
  `owner` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
  `responsible` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '责任人',
  `handler` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '处理人',
  `department_key` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门key',
  `department` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门',
  `team_key` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组key',
  `team` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `idx_owner` (`owner`),
  KEY `idx_level` (`level`),
  KEY `idx_iid` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
-- CREATE TABLE `x_review_user` (
--   `email` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '用户email',
--   `rid` int unsigned NOT NULL COMMENT 'review_id',
--   UNIQUE KEY `udx_er` (`email`,`rid`) COMMENT '关注',
--   KEY `idx_rid` (`rid`)
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
-- okr表
-- CREATE TABLE `x_okr` (
--   `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '主键id',
--   `year_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '年度',
--   `quarter_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '季度',
--   `creator` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '创建人',
--   `result` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '结果',
--   `target` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '目标',
--   `create_at` int NOT NULL DEFAULT '0' COMMENT '创建时间',
--   `update_at` int NOT NULL DEFAULT '0' COMMENT '更新时间',
--   PRIMARY KEY (`id`),
--   KEY `idx_email` (`creator`),
--   KEY `idx_year` (`year_str`)
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


-- alter table x_review
--     add `department_key` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门key';
-- alter table x_review
--     add `department` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '部门';
-- alter table x_review
--     add `team_key` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组key';
-- alter table x_review
--     add `team` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '组';