package model

import "github.com/zeromicro/go-zero/core/stores/sqlx"

var _ XOkrModel = (*customXOkrModel)(nil)

type (
	// XOkrModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOkrModel.
	XOkrModel interface {
		xOkrModel
		withSession(session sqlx.Session) XOkrModel
	}

	customXOkrModel struct {
		*defaultXOkrModel
	}
)

// NewXOkrModel returns a model for the database table.
func NewXOkrModel(conn sqlx.SqlConn) XOkrModel {
	return &customXOkrModel{
		defaultXOkrModel: newXOkrModel(conn),
	}
}

func (m *customXOkrModel) withSession(session sqlx.Session) XOkrModel {
	return NewXOkrModel(sqlx.NewSqlConnFromSession(session))
}
