// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"time"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	
)

func (m *defaultXOkrModel) BatchInsert(ctx context.Context, data *[]XOkr) error {
	now := time.Now().Unix()
	return m.conn.TransactCtx(ctx, func(ctx context.Context, session sqlx.Session) error {
        query := `INSERT INTO x_okr
		(target, result, creator, year_str, quarter_str, create_at, update_at)
		VALUES
		(?, ?, ?, ?, ?, ?, ?)`

        for _, item := range *data {
            _, err := session.ExecCtx(
				ctx, query, item.Target, item.Result, item.Creator, item.YearStr, item.QuarterStr, now, 0)
            if err != nil {
                return err
            }
        }
        return nil
    })
}

func (m *defaultXOkrModel) GetList(ctx context.Context, page, pageSize uint64, email, year, quantification string) (int64, []*XOkr, error) {
	// 先查询总数
	var total int64
	var list []*XOkr
	query := `SELECT COUNT(1) FROM x_okr WHERE creator = ? AND year_str = ? AND quarter_str = ?`
	err := m.conn.QueryRowCtx(ctx, &total, query, email, year, quantification)
	if err != nil {
		return 0, list, err
	}
	// 查询列表
	query = `SELECT * FROM x_okr WHERE creator = ? AND year_str = ? AND quarter_str = ? ORDER BY id DESC LIMIT ?, ?`
	err = m.conn.QueryRowsCtx(ctx, &list, query, email, year, quantification, (page-1)*pageSize, pageSize)
	if err != nil {
		return 0, list, err
	}
	return total, list, nil
}

func (m *defaultXOkrModel) UpOkr(ctx context.Context, data *XOkr) (*XOkr, error) {
	_, err := m.conn.Exec(`
	UPDATE x_okr SET 
	target = ?, result = ?, update_at = ?,
	year_str = ?, quarter_str = ?
	WHERE id = ? and creator = ?`,
	data.Target, data.Result, time.Now().Unix(), data.YearStr, data.QuarterStr,
	data.Id, data.Creator)
	if err != nil {
		return nil, err
	}
	return data, nil
}

func (m *defaultXOkrModel) DelOkr(ctx context.Context, id uint64, email string) error {
	_, err := m.conn.Exec("DELETE FROM x_okr WHERE id = ? AND creator = ?", id, email)
	return err
}
