// Code generated by goctl. DO NOT EDIT.

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOkrFieldNames          = builder.RawFieldNames(&XOkr{})
	xOkrRows                = strings.Join(xOkrFieldNames, ",")
	xOkrRowsExpectAutoSet   = strings.Join(stringx.Remove(xOkrFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOkrRowsWithPlaceHolder = strings.Join(stringx.Remove(xOkrFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOkrModel interface {
		Insert(ctx context.Context, data *XOkr) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XOkr, error)
		Update(ctx context.Context, data *XOkr) error
		Delete(ctx context.Context, id uint64) error
		BatchInsert(ctx context.Context, data *[]XOkr) error
		GetList(ctx context.Context, page, pageSize uint64, email, year, quantification string) (int64, []*XOkr, error)
		UpOkr(ctx context.Context, data *XOkr) (*XOkr, error)
		DelOkr(ctx context.Context, id uint64, email string) error

	}

	defaultXOkrModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOkr struct {
		Id         uint64 `db:"id"`          // 主键id
		YearStr    string `db:"year_str"`    // 年度
		QuarterStr string `db:"quarter_str"` // 季度
		Creator    string `db:"creator"`     // 创建人
		Result     string `db:"result"`      // 结果
		Target     string `db:"target"`      // 目标
		CreateAt   int64  `db:"create_at"`   // 创建时间
		UpdateAt   int64  `db:"update_at"`   // 更新时间
	}
)

func newXOkrModel(conn sqlx.SqlConn) *defaultXOkrModel {
	return &defaultXOkrModel{
		conn:  conn,
		table: "`x_okr`",
	}
}

func (m *defaultXOkrModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXOkrModel) FindOne(ctx context.Context, id uint64) (*XOkr, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xOkrRows, m.table)
	var resp XOkr
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrModel) Insert(ctx context.Context, data *XOkr) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?)", m.table, xOkrRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.YearStr, data.QuarterStr, data.Creator, data.Result, data.Target)
	return ret, err
}

func (m *defaultXOkrModel) Update(ctx context.Context, data *XOkr) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xOkrRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.YearStr, data.QuarterStr, data.Creator, data.Result, data.Target, data.Id)
	return err
}

func (m *defaultXOkrModel) tableName() string {
	return m.table
}
