package model

import (
	"context"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XReviewModel = (*customXReviewModel)(nil)

type (
	// XReviewModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXReviewModel.
	XReviewModel interface {
		xReviewModel
		withSession(session sqlx.Session) XReviewModel

		UpdateAndUser(ctx context.Context, data *XReview, users string) error
		InsertAndUser(ctx context.Context, data *XReview, users string) error
		FindOneAndUser(ctx context.Context, id uint64) (*XReviewUsers, error)
		GetList(ctx context.Context, page, pageSize uint64, levels, departmentKeys, teamKeys, responsible []string, startTime, endTime string) (int64, []*XReviewUsers, error)
	}

	customXReviewModel struct {
		*defaultXReviewModel
	}
)

// NewXReviewModel returns a model for the database table.
func NewXReviewModel(conn sqlx.SqlConn) XReviewModel {
	return &customXReviewModel{
		defaultXReviewModel: newXReviewModel(conn),
	}
}

func (m *customXReviewModel) withSession(session sqlx.Session) XReviewModel {
	return NewXReviewModel(sqlx.NewSqlConnFromSession(session))
}
