// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package model

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xReviewFieldNames          = builder.RawFieldNames(&XReview{})
	xReviewRows                = strings.Join(xReviewFieldNames, ",")
	xReviewRowsExpectAutoSet   = strings.Join(stringx.Remove(xReviewFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xReviewRowsWithPlaceHolder = strings.Join(stringx.Remove(xReviewFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xReviewModel interface {
		Insert(ctx context.Context, data *XReview) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XReview, error)
		Update(ctx context.Context, data *XReview) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXReviewModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XReview struct {
		Id            uint64    `db:"id"`             // 主键id
		Level         string    `db:"level"`          // 故障定级
		IssueId       uint64    `db:"issue_id"`       // issue_id
		Scope         string    `db:"scope"`          // 影响范围
		Review        string    `db:"review"`         // 回顾
		RootCause     string    `db:"root_cause"`     // 故障根因
		Scheme        string    `db:"scheme"`         // 修复方案
		Improvement   string    `db:"improvement"`    // 改进方案
		Kpi           string    `db:"kpi"`            // 关联绩效
		Remark        string    `db:"remark"`         // 备注
		Owner         string    `db:"owner"`          // 创建人
		Responsible   string    `db:"responsible"`    // 责任人
		Handler       string    `db:"handler"`        // 处理人
		DepartmentKey string    `db:"department_key"` // 部门key
		Department    string    `db:"department"`     // 部门
		TeamKey       string    `db:"team_key"`       // 组key
		Team          string    `db:"team"`           // 组
		CreatedAt     time.Time `db:"created_at"`     // 创建时间
		UpdatedAt     time.Time `db:"updated_at"`     // 更新时间
	}
)

func newXReviewModel(conn sqlx.SqlConn) *defaultXReviewModel {
	return &defaultXReviewModel{
		conn:  conn,
		table: "`x_review`",
	}
}

func (m *defaultXReviewModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXReviewModel) FindOne(ctx context.Context, id uint64) (*XReview, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xReviewRows, m.table)
	var resp XReview
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXReviewModel) Insert(ctx context.Context, data *XReview) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xReviewRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.Level, data.IssueId, data.Scope, data.Review, data.RootCause, data.Scheme, data.Improvement, data.Kpi, data.Remark, data.Owner, data.Responsible, data.Handler, data.DepartmentKey, data.Department, data.TeamKey, data.Team)
	return ret, err
}

func (m *defaultXReviewModel) Update(ctx context.Context, data *XReview) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xReviewRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.Level, data.IssueId, data.Scope, data.Review, data.RootCause, data.Scheme, data.Improvement, data.Kpi, data.Remark, data.Owner, data.Responsible, data.Handler, data.DepartmentKey, data.Department, data.TeamKey, data.Team, data.Id)
	return err
}

func (m *defaultXReviewModel) tableName() string {
	return m.table
}
