package efficiency_calc

import (
	"encoding/json"
	"oa-server/app/oacenter/oa_rpc/oa"
)

type EfficiencyCalcDTO struct {
	*XEfficiencyCalc
	CalcFormula []*oa.Item `db:"calc_formula"`
}
type EfficiencyCalcHistoryDTO struct {
	*XEfficiencyCalcHistory
	CalcFormula []*oa.Item `db:"calc_formula"`
}

func (x *XEfficiencyCalc) ToDTO() (*EfficiencyCalcDTO, error) {
	dto := &EfficiencyCalcDTO{XEfficiencyCalc: x}

	if !x.CalcFormula.Valid {
		return dto, nil
	}
	err := json.Unmarshal([]byte(x.CalcFormula.String), &dto.CalcFormula)
	if err != nil {
		return nil, err
	}

	return dto, nil
}

func (x *XEfficiencyCalcHistory) ToDTO() (*EfficiencyCalcHistoryDTO, error) {
	dto := &EfficiencyCalcHistoryDTO{XEfficiencyCalcHistory: x}
	if !x.CalcFormula.Valid {
		return dto, nil
	}
	err := json.Unmarshal([]byte(x.CalcFormula.String), &dto.CalcFormula)
	if err != nil {
		return nil, err
	}

	return dto, nil
}
