package efficiency_calc

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XEfficiencyCalcHistoryModel = (*customXEfficiencyCalcHistoryModel)(nil)

type (
	// XEfficiencyCalcHistoryModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXEfficiencyCalcHistoryModel.
	XEfficiencyCalcHistoryModel interface {
		xEfficiencyCalcHistoryModel
		ListHistory(ctx context.Context, req *ListHistoryReq) (int64, []*EfficiencyCalcHistoryDTO, error)
	}

	customXEfficiencyCalcHistoryModel struct {
		*defaultXEfficiencyCalcHistoryModel
	}
)

// NewXEfficiencyCalcHistoryModel returns a model for the database table.
func NewXEfficiencyCalcHistoryModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) XEfficiencyCalcHistoryModel {
	return &customXEfficiencyCalcHistoryModel{
		defaultXEfficiencyCalcHistoryModel: newXEfficiencyCalcHistoryModel(conn, c, opts...),
	}
}
