// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package efficiency_calc

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xEfficiencyCalcHistoryFieldNames          = builder.RawFieldNames(&XEfficiencyCalcHistory{})
	xEfficiencyCalcHistoryRows                = strings.Join(xEfficiencyCalcHistoryFieldNames, ",")
	xEfficiencyCalcHistoryRowsExpectAutoSet   = strings.Join(stringx.Remove(xEfficiencyCalcHistoryFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xEfficiencyCalcHistoryRowsWithPlaceHolder = strings.Join(stringx.Remove(xEfficiencyCalcHistoryFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXEfficiencyCalcHistoryIdPrefix = "cache:xEfficiencyCalcHistory:id:"
)

type (
	xEfficiencyCalcHistoryModel interface {
		Insert(ctx context.Context, data *XEfficiencyCalcHistory) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XEfficiencyCalcHistory, error)
		Update(ctx context.Context, data *XEfficiencyCalcHistory) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXEfficiencyCalcHistoryModel struct {
		sqlc.CachedConn
		table string
	}

	XEfficiencyCalcHistory struct {
		Id            uint64         `db:"id"`
		CreatedAt     time.Time      `db:"created_at"`
		UpdatedAt     time.Time      `db:"updated_at"`
		DeletedAt     sql.NullTime   `db:"deleted_at"`
		Operator      sql.NullString `db:"operator"`
		EffectiveTime sql.NullTime   `db:"effective_time"`
		CalcFormula   sql.NullString `db:"calc_formula"`
		CalcIndex     sql.NullInt64  `db:"calc_index"`
		Role          sql.NullInt64  `db:"role"`
		CalcId        sql.NullInt64  `db:"calc_id"`
		DepartmentKey sql.NullString `db:"department_key"`
	}
)

func newXEfficiencyCalcHistoryModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXEfficiencyCalcHistoryModel {
	return &defaultXEfficiencyCalcHistoryModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_efficiency_calc_history`",
	}
}

func (m *defaultXEfficiencyCalcHistoryModel) Delete(ctx context.Context, id uint64) error {
	xEfficiencyCalcHistoryIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcHistoryIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xEfficiencyCalcHistoryIdKey)
	return err
}

func (m *defaultXEfficiencyCalcHistoryModel) FindOne(ctx context.Context, id uint64) (*XEfficiencyCalcHistory, error) {
	xEfficiencyCalcHistoryIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcHistoryIdPrefix, id)
	var resp XEfficiencyCalcHistory
	err := m.QueryRowCtx(ctx, &resp, xEfficiencyCalcHistoryIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xEfficiencyCalcHistoryRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXEfficiencyCalcHistoryModel) Insert(ctx context.Context, data *XEfficiencyCalcHistory) (sql.Result, error) {
	xEfficiencyCalcHistoryIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcHistoryIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?)", m.table, xEfficiencyCalcHistoryRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.DeletedAt, data.Operator, data.EffectiveTime, data.CalcFormula, data.CalcIndex, data.Role, data.CalcId, data.DepartmentKey)
	}, xEfficiencyCalcHistoryIdKey)
	return ret, err
}

func (m *defaultXEfficiencyCalcHistoryModel) Update(ctx context.Context, data *XEfficiencyCalcHistory) error {
	xEfficiencyCalcHistoryIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcHistoryIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xEfficiencyCalcHistoryRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.DeletedAt, data.Operator, data.EffectiveTime, data.CalcFormula, data.CalcIndex, data.Role, data.CalcId, data.DepartmentKey, data.Id)
	}, xEfficiencyCalcHistoryIdKey)
	return err
}

func (m *defaultXEfficiencyCalcHistoryModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXEfficiencyCalcHistoryIdPrefix, primary)
}

func (m *defaultXEfficiencyCalcHistoryModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xEfficiencyCalcHistoryRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXEfficiencyCalcHistoryModel) tableName() string {
	return m.table
}
