package efficiency_calc

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XEfficiencyCalcModel = (*customXEfficiencyCalcModel)(nil)

type (
	// XEfficiencyCalcModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXEfficiencyCalcModel.
	XEfficiencyCalcModel interface {
		xEfficiencyCalcModel
		List(ctx context.Context, req *ListReq) (int64, []*EfficiencyCalcDTO, error)
	}

	customXEfficiencyCalcModel struct {
		*defaultXEfficiencyCalcModel
	}
)

// NewXEfficiencyCalcModel returns a model for the database table.
func NewXEfficiencyCalcModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) XEfficiencyCalcModel {
	return &customXEfficiencyCalcModel{
		defaultXEfficiencyCalcModel: newXEfficiencyCalcModel(conn, c, opts...),
	}
}
