// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package efficiency_calc

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xEfficiencyCalcFieldNames          = builder.RawFieldNames(&XEfficiencyCalc{})
	xEfficiencyCalcRows                = strings.Join(xEfficiencyCalcFieldNames, ",")
	xEfficiencyCalcRowsExpectAutoSet   = strings.Join(stringx.Remove(xEfficiencyCalcFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xEfficiencyCalcRowsWithPlaceHolder = strings.Join(stringx.Remove(xEfficiencyCalcFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXEfficiencyCalcIdPrefix = "cache:xEfficiencyCalc:id:"
)

type (
	xEfficiencyCalcModel interface {
		Insert(ctx context.Context, data *XEfficiencyCalc) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XEfficiencyCalc, error)
		Update(ctx context.Context, data *XEfficiencyCalc) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXEfficiencyCalcModel struct {
		sqlc.CachedConn
		table string
	}

	XEfficiencyCalc struct {
		Id                  int64          `db:"id"`
		DepartmentKey       sql.NullString `db:"department_key"`
		ParentDepartmentKey sql.NullString `db:"parent_department_key"`
		Role                sql.NullInt64  `db:"role"`
		CalcIndex           sql.NullInt64  `db:"calc_index"`
		CalcFormula         sql.NullString `db:"calc_formula"`
		EffectiveTime       sql.NullTime   `db:"effective_time"`
		UpdateBy            sql.NullString `db:"update_by"`
		CreatedAt           time.Time      `db:"created_at"`
		UpdatedAt           time.Time      `db:"updated_at"`
		DeletedAt           sql.NullTime   `db:"deleted_at"`
	}
)

func newXEfficiencyCalcModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXEfficiencyCalcModel {
	return &defaultXEfficiencyCalcModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_efficiency_calc`",
	}
}

func (m *defaultXEfficiencyCalcModel) Delete(ctx context.Context, id int64) error {
	xEfficiencyCalcIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xEfficiencyCalcIdKey)
	return err
}

func (m *defaultXEfficiencyCalcModel) FindOne(ctx context.Context, id int64) (*XEfficiencyCalc, error) {
	xEfficiencyCalcIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcIdPrefix, id)
	var resp XEfficiencyCalc
	err := m.QueryRowCtx(ctx, &resp, xEfficiencyCalcIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xEfficiencyCalcRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXEfficiencyCalcModel) Insert(ctx context.Context, data *XEfficiencyCalc) (sql.Result, error) {
	xEfficiencyCalcIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?)", m.table, xEfficiencyCalcRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.DepartmentKey, data.ParentDepartmentKey, data.Role, data.CalcIndex, data.CalcFormula, data.EffectiveTime, data.UpdateBy, data.DeletedAt)
	}, xEfficiencyCalcIdKey)
	return ret, err
}

func (m *defaultXEfficiencyCalcModel) Update(ctx context.Context, data *XEfficiencyCalc) error {
	xEfficiencyCalcIdKey := fmt.Sprintf("%s%v", cacheXEfficiencyCalcIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xEfficiencyCalcRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.DepartmentKey, data.ParentDepartmentKey, data.Role, data.CalcIndex, data.CalcFormula, data.EffectiveTime, data.UpdateBy, data.DeletedAt, data.Id)
	}, xEfficiencyCalcIdKey)
	return err
}

func (m *defaultXEfficiencyCalcModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXEfficiencyCalcIdPrefix, primary)
}

func (m *defaultXEfficiencyCalcModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xEfficiencyCalcRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXEfficiencyCalcModel) tableName() string {
	return m.table
}
