package issue

import (
	"encoding/json"

	"oa-server/app/oacenter/model"
	"oa-server/app/oacenter/oa_rpc/oa"
)

type IssueMetricsDTO struct {
	*XIssueMetrics
	Infos     []*oa.Infos
	ProdBug   model.MetricInfo
	NonProd   model.MetricInfo
	BugEscape model.MetricInfo
}

func (x *XIssueMetrics) MarshalInfos(infos []*oa.Infos) (string, error) {
	b, err := json.Marshal(infos)
	if err != nil {
		return "", err
	}

	return string(b), nil
}

func (x *XIssueMetrics) ToDTO() (*IssueMetricsDTO, error) {
	dto := &IssueMetricsDTO{XIssueMetrics: x}

	if x.Infos.Valid {
		err := json.Unmarshal([]byte(x.Infos.String), &dto.Infos)
		if err != nil {
			return nil, err
		}
	}

	if x.ProdBug.Valid {
		err := json.Unmarshal([]byte(x.ProdBug.String), &dto.ProdBug)
		if err != nil {
			return nil, err
		}
	}

	if x.NonProd.Valid {
		err := json.Unmarshal([]byte(x.NonProd.String), &dto.NonProd)
		if err != nil {
			return nil, err
		}
	}
	if x.BugEscape.Valid {
		err := json.Unmarshal([]byte(x.BugEscape.String), &dto.BugEscape)
		if err != nil {
			return nil, err
		}
	}
	return dto, nil
}

var WorkItemPriorityMap = map[string]string{
	"0":         "P0",
	"1":         "P1",
	"2":         "P2",
	"1xg7_o7rf": "P3",
	"jun_a16zp": "P4",
}

var WorkItemTypeMap = map[string]string{
	"ios":       "线下业务BUG",
	"android":   "线下UI BUG",
	"fe":        "线上BUG",
	"fn8kqr4ll": "稳定性/性能bug",
}

var WorkItemReasonMap = map[string]string{
	"1jwu9xmzp": "开发错误",
	"ng333uqpa": "需求文档未说明",
	"zt2e0ppvp": "交互文档未说明",
	"tf986rs9s": "历史遗留问题",
}
