package issue

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XIssueMetricsModel = (*customXIssueMetricsModel)(nil)

type (
	// XIssueMetricsModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXIssueMetricsModel.
	XIssueMetricsModel interface {
		xIssueMetricsModel
		DeleteByFiled(ctx context.Context, req DeleteReq) error
		List(ctx context.Context, req *ListReq) (int64, []*IssueMetricsDTO, error)
	}

	customXIssueMetricsModel struct {
		*defaultXIssueMetricsModel
	}
)

// NewXIssueMetricsModel returns a model for the database table.
func NewXIssueMetricsModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) XIssueMetricsModel {
	return &customXIssueMetricsModel{
		defaultXIssueMetricsModel: newXIssueMetricsModel(conn, c, opts...),
	}
}
