// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package issue

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xIssueMetricsFieldNames          = builder.RawFieldNames(&XIssueMetrics{})
	xIssueMetricsRows                = strings.Join(xIssueMetricsFieldNames, ",")
	xIssueMetricsRowsExpectAutoSet   = strings.Join(stringx.Remove(xIssueMetricsFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xIssueMetricsRowsWithPlaceHolder = strings.Join(stringx.Remove(xIssueMetricsFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXIssueMetricsIdPrefix = "cache:xIssueMetrics:id:"
)

type (
	xIssueMetricsModel interface {
		Insert(ctx context.Context, data *XIssueMetrics) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XIssueMetrics, error)
		Update(ctx context.Context, data *XIssueMetrics) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXIssueMetricsModel struct {
		sqlc.CachedConn
		table string
	}

	XIssueMetrics struct {
		Id         int64           `db:"id"`
		CreatedAt  time.Time       `db:"created_at"`
		UpdatedAt  time.Time       `db:"updated_at"`
		DeletedAt  sql.NullTime    `db:"deleted_at"`
		PeriodType sql.NullInt64   `db:"period_type"`
		Employee   sql.NullString  `db:"employee"`
		DateFromTo sql.NullString  `db:"date_from_to"`
		Department sql.NullString  `db:"department"`
		ProjectKey sql.NullString  `db:"project_key"`
		Infos      sql.NullString  `db:"infos"`
		Role       sql.NullInt64   `db:"role"`
		ProdBug    sql.NullString  `db:"prod_bug"`
		NonProd    sql.NullString  `db:"non_prod"`
		BugEscape  sql.NullString  `db:"bug_escape"`
		Score      sql.NullFloat64 `db:"score"`
	}
)

func newXIssueMetricsModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXIssueMetricsModel {
	return &defaultXIssueMetricsModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_issue_metrics`",
	}
}

func (m *defaultXIssueMetricsModel) Delete(ctx context.Context, id int64) error {
	xIssueMetricsIdKey := fmt.Sprintf("%s%v", cacheXIssueMetricsIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xIssueMetricsIdKey)
	return err
}

func (m *defaultXIssueMetricsModel) FindOne(ctx context.Context, id int64) (*XIssueMetrics, error) {
	xIssueMetricsIdKey := fmt.Sprintf("%s%v", cacheXIssueMetricsIdPrefix, id)
	var resp XIssueMetrics
	err := m.QueryRowCtx(ctx, &resp, xIssueMetricsIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssueMetricsRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXIssueMetricsModel) Insert(ctx context.Context, data *XIssueMetrics) (sql.Result, error) {
	xIssueMetricsIdKey := fmt.Sprintf("%s%v", cacheXIssueMetricsIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xIssueMetricsRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.DeletedAt, data.PeriodType, data.Employee, data.DateFromTo, data.Department, data.ProjectKey, data.Infos, data.Role, data.ProdBug, data.NonProd, data.BugEscape, data.Score)
	}, xIssueMetricsIdKey)
	return ret, err
}

func (m *defaultXIssueMetricsModel) Update(ctx context.Context, data *XIssueMetrics) error {
	xIssueMetricsIdKey := fmt.Sprintf("%s%v", cacheXIssueMetricsIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xIssueMetricsRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.DeletedAt, data.PeriodType, data.Employee, data.DateFromTo, data.Department, data.ProjectKey, data.Infos, data.Role, data.ProdBug, data.NonProd, data.BugEscape, data.Score, data.Id)
	}, xIssueMetricsIdKey)
	return err
}

func (m *defaultXIssueMetricsModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXIssueMetricsIdPrefix, primary)
}

func (m *defaultXIssueMetricsModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xIssueMetricsRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXIssueMetricsModel) tableName() string {
	return m.table
}
