package monitor_metrics

import (
	"encoding/json"

	"oa-server/app/oacenter/model"
)

type MonitorMetricsDTO struct {
	*XMonitorMetrics
	FailureRecurrenceRate  model.MetricInfo
	AverageProcessingTime  model.MetricInfo
	AverageResolutionTime  model.MetricInfo
	EffectiveHandledEvents model.MetricInfo
	BizRuleHitRate         model.MetricInfo
	BizEventAssignmentRate model.MetricInfo
}

func (x *XMonitorMetrics) ToDTO() (*MonitorMetricsDTO, error) {
	dto := &MonitorMetricsDTO{XMonitorMetrics: x}

	if x.FailureRecurrenceRate.Valid {
		err := json.Unmarshal([]byte(x.FailureRecurrenceRate.String), &dto.FailureRecurrenceRate)
		if err != nil {
			return nil, err
		}
	}
	if x.AverageProcessingTime.Valid {
		err := json.Unmarshal([]byte(x.AverageProcessingTime.String), &dto.AverageProcessingTime)
		if err != nil {
			return nil, err
		}
	}
	if x.AverageResolutionTime.Valid {
		err := json.Unmarshal([]byte(x.AverageResolutionTime.String), &dto.AverageResolutionTime)
		if err != nil {
			return nil, err
		}
	}
	if x.EffectiveHandledEvents.Valid {
		err := json.Unmarshal([]byte(x.EffectiveHandledEvents.String), &dto.EffectiveHandledEvents)
		if err != nil {
			return nil, err
		}
	}
	if x.BizRuleHitRate.Valid {
		err := json.Unmarshal([]byte(x.BizRuleHitRate.String), &dto.BizRuleHitRate)
		if err != nil {
			return nil, err
		}
	}
	if x.BizEventAssignmentRate.Valid {
		err := json.Unmarshal([]byte(x.BizEventAssignmentRate.String), &dto.BizEventAssignmentRate)
		if err != nil {
			return nil, err
		}
	}

	return dto, nil
}
