package monitor_metrics

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XMonitorMetricsModel = (*customXMonitorMetricsModel)(nil)

type (
	// XMonitorMetricsModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXMonitorMetricsModel.
	XMonitorMetricsModel interface {
		xMonitorMetricsModel
		List(ctx context.Context, req *ListReq) (int64, []*XMonitorMetrics, error)
		DeleteMetrics(ctx context.Context, periodType int64, dateFromTo string, employee string) error
	}

	customXMonitorMetricsModel struct {
		*defaultXMonitorMetricsModel
	}
)

// NewXMonitorMetricsModel returns a model for the database table.
func NewXMonitorMetricsModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) XMonitorMetricsModel {
	return &customXMonitorMetricsModel{
		defaultXMonitorMetricsModel: newXMonitorMetricsModel(conn, c, opts...),
	}
}
