// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package monitor_metrics

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/cache"
	"github.com/zeromicro/go-zero/core/stores/sqlc"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xMonitorMetricsFieldNames          = builder.RawFieldNames(&XMonitorMetrics{})
	xMonitorMetricsRows                = strings.Join(xMonitorMetricsFieldNames, ",")
	xMonitorMetricsRowsExpectAutoSet   = strings.Join(stringx.Remove(xMonitorMetricsFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xMonitorMetricsRowsWithPlaceHolder = strings.Join(stringx.Remove(xMonitorMetricsFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	cacheXMonitorMetricsIdPrefix = "cache:xMonitorMetrics:id:"
)

type (
	xMonitorMetricsModel interface {
		Insert(ctx context.Context, data *XMonitorMetrics) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XMonitorMetrics, error)
		Update(ctx context.Context, data *XMonitorMetrics) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXMonitorMetricsModel struct {
		sqlc.CachedConn
		table string
	}

	XMonitorMetrics struct {
		Id                     int64           `db:"id"`
		TotalEvents            sql.NullInt64   `db:"total_events"`
		PeriodType             sql.NullInt64   `db:"period_type"`
		Employee               sql.NullString  `db:"employee"`
		DateFromTo             sql.NullString  `db:"date_from_to"`
		FailureRecurrenceRate  sql.NullString  `db:"failure_recurrence_rate"`
		AverageProcessingTime  sql.NullString  `db:"average_processing_time"`
		AverageResolutionTime  sql.NullString  `db:"average_resolution_time"`
		EffectiveHandledEvents sql.NullString  `db:"effective_handled_events"`
		BizRuleHitRate         sql.NullString  `db:"biz_rule_hit_rate"`
		BizEventAssignmentRate sql.NullString  `db:"biz_event_assignment_rate"`
		CreatedAt              time.Time       `db:"created_at"`
		UpdatedAt              time.Time       `db:"updated_at"`
		DeletedAt              sql.NullTime    `db:"deleted_at"`
		DepartmentKey          sql.NullString  `db:"department_key"`
		DepartmentName         sql.NullString  `db:"department_name"`
		NickName               sql.NullString  `db:"nick_name"`
		Score                  sql.NullFloat64 `db:"score"`
	}
)

func newXMonitorMetricsModel(conn sqlx.SqlConn, c cache.CacheConf, opts ...cache.Option) *defaultXMonitorMetricsModel {
	return &defaultXMonitorMetricsModel{
		CachedConn: sqlc.NewConn(conn, c, opts...),
		table:      "`x_monitor_metrics`",
	}
}

func (m *defaultXMonitorMetricsModel) Delete(ctx context.Context, id int64) error {
	xMonitorMetricsIdKey := fmt.Sprintf("%s%v", cacheXMonitorMetricsIdPrefix, id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
		return conn.ExecCtx(ctx, query, id)
	}, xMonitorMetricsIdKey)
	return err
}

func (m *defaultXMonitorMetricsModel) FindOne(ctx context.Context, id int64) (*XMonitorMetrics, error) {
	xMonitorMetricsIdKey := fmt.Sprintf("%s%v", cacheXMonitorMetricsIdPrefix, id)
	var resp XMonitorMetrics
	err := m.QueryRowCtx(ctx, &resp, xMonitorMetricsIdKey, func(ctx context.Context, conn sqlx.SqlConn, v any) error {
		query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xMonitorMetricsRows, m.table)
		return conn.QueryRowCtx(ctx, v, query, id)
	})
	switch err {
	case nil:
		return &resp, nil
	case sqlc.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXMonitorMetricsModel) Insert(ctx context.Context, data *XMonitorMetrics) (sql.Result, error) {
	xMonitorMetricsIdKey := fmt.Sprintf("%s%v", cacheXMonitorMetricsIdPrefix, data.Id)
	ret, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xMonitorMetricsRowsExpectAutoSet)
		return conn.ExecCtx(ctx, query, data.TotalEvents, data.PeriodType, data.Employee, data.DateFromTo, data.FailureRecurrenceRate, data.AverageProcessingTime, data.AverageResolutionTime, data.EffectiveHandledEvents, data.BizRuleHitRate, data.BizEventAssignmentRate, data.DeletedAt, data.DepartmentKey, data.DepartmentName, data.NickName, data.Score)
	}, xMonitorMetricsIdKey)
	return ret, err
}

func (m *defaultXMonitorMetricsModel) Update(ctx context.Context, data *XMonitorMetrics) error {
	xMonitorMetricsIdKey := fmt.Sprintf("%s%v", cacheXMonitorMetricsIdPrefix, data.Id)
	_, err := m.ExecCtx(ctx, func(ctx context.Context, conn sqlx.SqlConn) (result sql.Result, err error) {
		query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xMonitorMetricsRowsWithPlaceHolder)
		return conn.ExecCtx(ctx, query, data.TotalEvents, data.PeriodType, data.Employee, data.DateFromTo, data.FailureRecurrenceRate, data.AverageProcessingTime, data.AverageResolutionTime, data.EffectiveHandledEvents, data.BizRuleHitRate, data.BizEventAssignmentRate, data.DeletedAt, data.DepartmentKey, data.DepartmentName, data.NickName, data.Score, data.Id)
	}, xMonitorMetricsIdKey)
	return err
}

func (m *defaultXMonitorMetricsModel) formatPrimary(primary any) string {
	return fmt.Sprintf("%s%v", cacheXMonitorMetricsIdPrefix, primary)
}

func (m *defaultXMonitorMetricsModel) queryPrimary(ctx context.Context, conn sqlx.SqlConn, v, primary any) error {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xMonitorMetricsRows, m.table)
	return conn.QueryRowCtx(ctx, v, query, primary)
}

func (m *defaultXMonitorMetricsModel) tableName() string {
	return m.table
}
