package okr

import (
	"database/sql"
	"fmt"
	"time"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

func (m *defaultXOkrMsgModel) InsertWithSession(conn sqlx.Session, data *XOkrMsg) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?)", m.table, xOkrMsgRowsExpectAutoSet)
	ret, err := conn.Exec(query, data.FromUser, data.ToUser, data.Type, data.Content, data.ApprovalStatus, data.StartDate, data.EndDate)
	return ret, err
}

type MsgListReq struct {
	StartDate time.Time
	EndDate   time.Time
	ToUser    string
	Page      int
	PageSize  int
}

func (m *defaultXOkrMsgModel) List(data *MsgListReq) (int64, []*XOkrMsg, error) {
	offset := (data.Page - 1) * data.PageSize
	limit := data.PageSize
	var total int64
	err := m.conn.QueryRow(&total, "select count(*) from "+m.table+" where start_date = ? and end_date = ? and to_user = ?", data.StartDate, data.EndDate, data.ToUser)
	if err != nil {
		return 0, nil, err
	}
	msgs := make([]*XOkrMsg, 0)
	query := fmt.Sprintf("select * from %s where start_date = ? and end_date = ? and to_user = ? order by id desc limit ? offset ?", m.table)
	err = m.conn.QueryRows(&msgs, query, data.StartDate, data.EndDate, data.ToUser, limit, offset)
	if err != nil {
		return 0, nil, err
	}
	return total, msgs, nil
}

func (m *defaultXOkrMsgModel) UnHandledMessage(data *MsgListReq) (int64, error) {
	query := fmt.Sprintf("select count(*) from %s where start_date = ? and end_date = ? and to_user = ? and approval_status = ?", m.table)
	var total int64
	err := m.conn.QueryRow(&total, query, data.StartDate, data.EndDate, data.ToUser, 1)
	if err != nil {
		return 0, err
	}
	return total, nil
}
