package okr

import (
	"context"
	"fmt"
	"strings"
)

type CountValue struct {
	Total int64 `db:"total"`
}
type FindOkrPeriodByUsersAndTimeQuery struct {
	Emails    []string
	StartDate string
	EndDate   string
	PageNum   int64
	PageSize  int64
}

func (m *customXOkrPeriodModel) FindOkrPeriodByUsersAndTime(ctx context.Context, q FindOkrPeriodByUsersAndTimeQuery) (int64, OkrPeriodList, error) {
	if q.PageNum <= 0 {
		q.PageNum = 1
	}

	offset := (q.PageNum - 1) * q.PageSize
	var conditions []string
	var args []any
	if len(q.Emails) > 0 {
		placeholders := make([]string, len(q.Emails))
		for i, v := range q.Emails {
			placeholders[i] = "?"
			args = append(args, v)
		}
		conditions = append(conditions, fmt.Sprintf("`owner` in (%s)", strings.Join(placeholders, ",")))
	}

	if q.StartDate != "" {
		conditions = append(conditions, "`start_date` = ?")
		args = append(args, q.StartDate)
	}
	if q.EndDate != "" {
		conditions = append(conditions, "`end_date` = ?")
		args = append(args, q.EndDate)
	}

	var countValue CountValue
	countQuery := fmt.Sprintf("select count(*) as `total` from %s where %s", m.table, strings.Join(conditions, " and "))
	if err := m.conn.QueryRowPartialCtx(ctx, &countValue, countQuery, args...); err != nil {
		return 0, nil, err
	}

	query := fmt.Sprintf("select * from %s where %s limit ? offset ?", m.table, strings.Join(conditions, " and "))
	args = append(args, q.PageSize, offset)
	var list OkrPeriodList
	err := m.conn.QueryRowsCtx(ctx, &list, query, args...)
	return countValue.Total, list, err
}

type OkrPeriodList []*XOkrPeriod

func (m *defaultXOkrPeriodModel) SetStatusFromTo(periodId, from, to int64) error {
	query := fmt.Sprintf("update %s set approval_status = ? where period_id = ? and approval_status = ?", m.table)
	_, err := m.conn.Exec(query, to, periodId, from)
	return err
}

// GetAllConfirmingOkrPeriod 获取所有状态为2的OKR
func (m *defaultXOkrPeriodModel) GetOkrPeriodByStatus(status int64) (OkrPeriodList, error) {
	query := fmt.Sprintf("select * from %s where `approval_status` = ?", m.table)
	var list OkrPeriodList
	err := m.conn.QueryRows(&list, query, status)
	return list, err
}
