package okr

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XOkrAlignmentModel = (*customXOkrAlignmentModel)(nil)

type (
	// XOkrAlignmentModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOkrAlignmentModel.
	XOkrAlignmentModel interface {
		xOkrAlignmentModel
		withSession(session sqlx.Session) XOkrAlignmentModel

		BulkSetAlignWithUser(ctx context.Context, session sqlx.Session, alignWithEntityId int64, alignWithUser string) (sql.Result, error)
		FindByAlignWithEntityId(alignWithEntityId int64) ([]*XOkrAlignment, error)
		BulkUpdatePosition(ctx context.Context, session sqlx.Session, entityIdToPosition map[int64]int64) (sql.Result, error)
		GetAlignmentParents(ctx context.Context, session sqlx.Session, entityIds []int64, includePending bool) (list []*XOkrAlignment, err error)
		GetAlignmentChildren(ctx context.Context, session sqlx.Session, alignWithEntityIds []int64, includePending bool) (list []*XOkrAlignment, err error)
		GetAlignedChildren(ctx context.Context, alignWithEntityIds []int64) (list OkrAlignmentList, err error)
		GetAlignmentByAssign(ctx context.Context, session sqlx.Session, entityIds []int64) (list []*XOkrAlignment, err error)
		TransDelete(session sqlx.Session, ids []int64) (err error)
		DeleteByIds(ids []int64) error
		DeleteByAlignWithEntityIdAndUserEmail(ctx context.Context, session sqlx.Session, entityId int64, userEmail string) error
		DeleteByEntityId(ctx context.Context, session sqlx.Session, entityId int64) error
		GetAlignWithEntityIdAndAlignID(ctx context.Context, entityId int64, alignID int64) (list OkrAlignmentList, err error)
		FindAllByUserAndAlignWithEntitiyId(ctx context.Context, userEmail string, alignWithEntityId int64) (list OkrAlignmentList, err error)
		TransGetOneByUserAndAlignWithEntityId(ctx context.Context, session sqlx.Session, userEmail string, alignWithEntityId, entityId int64) (*XOkrAlignment, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, newData *XOkrAlignment) error
		GetByEntityId(ctx context.Context, entityId int64) (*XOkrAlignment, error)
	}

	customXOkrAlignmentModel struct {
		*defaultXOkrAlignmentModel
	}
)

// NewXOkrAlignmentModel returns a model for the database table.
func NewXOkrAlignmentModel(conn sqlx.SqlConn) XOkrAlignmentModel {
	return &customXOkrAlignmentModel{
		defaultXOkrAlignmentModel: newXOkrAlignmentModel(conn),
	}
}

func (m *customXOkrAlignmentModel) withSession(session sqlx.Session) XOkrAlignmentModel {
	return NewXOkrAlignmentModel(sqlx.NewSqlConnFromSession(session))
}
