// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package okr

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOkrAlignmentFieldNames          = builder.RawFieldNames(&XOkrAlignment{})
	xOkrAlignmentRows                = strings.Join(xOkrAlignmentFieldNames, ",")
	xOkrAlignmentRowsExpectAutoSet   = strings.Join(stringx.Remove(xOkrAlignmentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOkrAlignmentRowsWithPlaceHolder = strings.Join(stringx.Remove(xOkrAlignmentFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOkrAlignmentModel interface {
		Insert(ctx context.Context, data *XOkrAlignment) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XOkrAlignment, error)
		FindOneByEntityIdAlignWithEntity(ctx context.Context, entityId int64, alignWithEntity int64) (*XOkrAlignment, error)
		Update(ctx context.Context, data *XOkrAlignment) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXOkrAlignmentModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOkrAlignment struct {
		Id                int64     `db:"id"`                  // id
		EntityId          int64     `db:"entity_id"`           // 下属的entity
		AlignWithEntity   int64     `db:"align_with_entity"`   // 领导的entity
		AlignWithUser     string    `db:"align_with_user"`     // 被对齐条目的负责人（领导）【冗余的， 由x_alignment表记录的align_with_entity字段决定】
		AlignWithPosition int64     `db:"align_with_position"` // 在领导视图中的元素序号
		AlignWithWeight   float64   `db:"align_with_weight"`   // 在领导视图中的元素权重
		Intended          int64     `db:"intended"`            // 下属尝试将这个条目对齐到某个领导的条目: 0:已批复同意对齐 1:仅申请未批复
		ByAssign          int64     `db:"by_assign"`           // 对齐关系是否由领导的分配动作产生: 0:否 1:是
		CreatedAt         time.Time `db:"created_at"`          // 创建时间
		UpdatedAt         time.Time `db:"updated_at"`          // 更新时间
	}
)

func newXOkrAlignmentModel(conn sqlx.SqlConn) *defaultXOkrAlignmentModel {
	return &defaultXOkrAlignmentModel{
		conn:  conn,
		table: "`x_okr_alignment`",
	}
}

func (m *defaultXOkrAlignmentModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXOkrAlignmentModel) FindOne(ctx context.Context, id int64) (*XOkrAlignment, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xOkrAlignmentRows, m.table)
	var resp XOkrAlignment
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrAlignmentModel) FindOneByEntityIdAlignWithEntity(ctx context.Context, entityId int64, alignWithEntity int64) (*XOkrAlignment, error) {
	var resp XOkrAlignment
	query := fmt.Sprintf("select %s from %s where `entity_id` = ? and `align_with_entity` = ? limit 1", xOkrAlignmentRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, entityId, alignWithEntity)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrAlignmentModel) Insert(ctx context.Context, data *XOkrAlignment) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?)", m.table, xOkrAlignmentRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.EntityId, data.AlignWithEntity, data.AlignWithUser, data.AlignWithPosition, data.AlignWithWeight, data.Intended, data.ByAssign)
	return ret, err
}

func (m *defaultXOkrAlignmentModel) Update(ctx context.Context, newData *XOkrAlignment) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xOkrAlignmentRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, newData.EntityId, newData.AlignWithEntity, newData.AlignWithUser, newData.AlignWithPosition, newData.AlignWithWeight, newData.Intended, newData.ByAssign, newData.Id)
	return err
}

func (m *defaultXOkrAlignmentModel) tableName() string {
	return m.table
}
