package okr

import (
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XOkrMsgModel = (*customXOkrMsgModel)(nil)

type (
	// XOkrMsgModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOkrMsgModel.
	XOkrMsgModel interface {
		xOkrMsgModel
		withSession(session sqlx.Session) XOkrMsgModel
		InsertWithSession(conn sqlx.Session, data *XOkrMsg) (sql.Result, error)
		List(data *MsgListReq) (int64, []*XOkrMsg, error)
		UnHandledMessage(data *MsgListReq) (int64, error)
	}

	customXOkrMsgModel struct {
		*defaultXOkrMsgModel
	}
)

// NewXOkrMsgModel returns a model for the database table.
func NewXOkrMsgModel(conn sqlx.SqlConn) XOkrMsgModel {
	return &customXOkrMsgModel{
		defaultXOkrMsgModel: newXOkrMsgModel(conn),
	}
}

func (m *customXOkrMsgModel) withSession(session sqlx.Session) XOkrMsgModel {
	return NewXOkrMsgModel(sqlx.NewSqlConnFromSession(session))
}
