// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package okr

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOkrMsgFieldNames          = builder.RawFieldNames(&XOkrMsg{})
	xOkrMsgRows                = strings.Join(xOkrMsgFieldNames, ",")
	xOkrMsgRowsExpectAutoSet   = strings.Join(stringx.Remove(xOkrMsgFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOkrMsgRowsWithPlaceHolder = strings.Join(stringx.Remove(xOkrMsgFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOkrMsgModel interface {
		Insert(ctx context.Context, data *XOkrMsg) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XOkrMsg, error)
		Update(ctx context.Context, data *XOkrMsg) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXOkrMsgModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOkrMsg struct {
		Id             int64     `db:"id"`              // id
		FromUser       string    `db:"from_user"`       // 发消息人
		ToUser         string    `db:"to_user"`         // 收消息人
		Type           int64     `db:"type"`            // 消息类型：1:对齐Req 2:对齐Resp 3:分配Req 4:分配Resp 5:确认Req 6:确认Resp
		Content        string    `db:"content"`         // 详情json {"entity_id":10,...} 具体处理方式在content里，因 Type 而异
		ApprovalStatus int64     `db:"approval_status"` // 处理方式枚举: 1:未处理 2:已处理
		StartDate      time.Time `db:"start_date"`      // 冗余的okr周期开始时间
		EndDate        time.Time `db:"end_date"`        // 冗余的okr周期结束时间
		CreatedAt      time.Time `db:"created_at"`      // 创建时间(发消息时间)
		UpdatedAt      time.Time `db:"updated_at"`      // 更新时间
	}
)

func newXOkrMsgModel(conn sqlx.SqlConn) *defaultXOkrMsgModel {
	return &defaultXOkrMsgModel{
		conn:  conn,
		table: "`x_okr_msg`",
	}
}

func (m *defaultXOkrMsgModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXOkrMsgModel) FindOne(ctx context.Context, id int64) (*XOkrMsg, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xOkrMsgRows, m.table)
	var resp XOkrMsg
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrMsgModel) Insert(ctx context.Context, data *XOkrMsg) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?)", m.table, xOkrMsgRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.FromUser, data.ToUser, data.Type, data.Content, data.ApprovalStatus, data.StartDate, data.EndDate)
	return ret, err
}

func (m *defaultXOkrMsgModel) Update(ctx context.Context, data *XOkrMsg) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xOkrMsgRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.FromUser, data.ToUser, data.Type, data.Content, data.ApprovalStatus, data.StartDate, data.EndDate, data.Id)
	return err
}

func (m *defaultXOkrMsgModel) tableName() string {
	return m.table
}
