package okr

import "github.com/zeromicro/go-zero/core/stores/sqlx"

var _ XOkrOperatingHistoryModel = (*customXOkrOperatingHistoryModel)(nil)

type (
	// XOkrOperatingHistoryModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOkrOperatingHistoryModel.
	XOkrOperatingHistoryModel interface {
		xOkrOperatingHistoryModel
		withSession(session sqlx.Session) XOkrOperatingHistoryModel
	}

	customXOkrOperatingHistoryModel struct {
		*defaultXOkrOperatingHistoryModel
	}
)

// NewXOkrOperatingHistoryModel returns a model for the database table.
func NewXOkrOperatingHistoryModel(conn sqlx.SqlConn) XOkrOperatingHistoryModel {
	return &customXOkrOperatingHistoryModel{
		defaultXOkrOperatingHistoryModel: newXOkrOperatingHistoryModel(conn),
	}
}

func (m *customXOkrOperatingHistoryModel) withSession(session sqlx.Session) XOkrOperatingHistoryModel {
	return NewXOkrOperatingHistoryModel(sqlx.NewSqlConnFromSession(session))
}
