// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package okr

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOkrOperatingHistoryFieldNames          = builder.RawFieldNames(&XOkrOperatingHistory{})
	xOkrOperatingHistoryRows                = strings.Join(xOkrOperatingHistoryFieldNames, ",")
	xOkrOperatingHistoryRowsExpectAutoSet   = strings.Join(stringx.Remove(xOkrOperatingHistoryFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOkrOperatingHistoryRowsWithPlaceHolder = strings.Join(stringx.Remove(xOkrOperatingHistoryFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOkrOperatingHistoryModel interface {
		Insert(ctx context.Context, data *XOkrOperatingHistory) (sql.Result, error)
		FindOne(ctx context.Context, id int64) (*XOkrOperatingHistory, error)
		Update(ctx context.Context, data *XOkrOperatingHistory) error
		Delete(ctx context.Context, id int64) error
	}

	defaultXOkrOperatingHistoryModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOkrOperatingHistory struct {
		Id            int64     `db:"id"`
		Table         string    `db:"table"`          // 表
		Pk            int64     `db:"pk"`             // 行
		OperatingType string    `db:"operating_type"` // 操作类型cud
		OldValue      string    `db:"old_value"`      // 旧值
		NewValue      string    `db:"new_value"`      // 新值
		User          string    `db:"user"`           // 操作人
		CreatedAt     time.Time `db:"created_at"`     // 创建时间（操作时间）
	}
)

func newXOkrOperatingHistoryModel(conn sqlx.SqlConn) *defaultXOkrOperatingHistoryModel {
	return &defaultXOkrOperatingHistoryModel{
		conn:  conn,
		table: "`x_okr_operating_history`",
	}
}

func (m *defaultXOkrOperatingHistoryModel) Delete(ctx context.Context, id int64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXOkrOperatingHistoryModel) FindOne(ctx context.Context, id int64) (*XOkrOperatingHistory, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xOkrOperatingHistoryRows, m.table)
	var resp XOkrOperatingHistory
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrOperatingHistoryModel) Insert(ctx context.Context, data *XOkrOperatingHistory) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?)", m.table, xOkrOperatingHistoryRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.Table, data.Pk, data.OperatingType, data.OldValue, data.NewValue, data.User)
	return ret, err
}

func (m *defaultXOkrOperatingHistoryModel) Update(ctx context.Context, data *XOkrOperatingHistory) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xOkrOperatingHistoryRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.Table, data.Pk, data.OperatingType, data.OldValue, data.NewValue, data.User, data.Id)
	return err
}

func (m *defaultXOkrOperatingHistoryModel) tableName() string {
	return m.table
}
