package okr

import (
	"context"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XOkrPeriodModel = (*customXOkrPeriodModel)(nil)

type (
	// XOkrPeriodModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOkrPeriodModel.
	XOkrPeriodModel interface {
		xOkrPeriodModel

		FindOkrPeriodByUsersAndTime(ctx context.Context, q FindOkrPeriodByUsersAndTimeQuery) (int64, OkrPeriodList, error)
		SetStatusFromTo(periodId, from, to int64) error
		GetOkrPeriodByStatus(status int64) (OkrPeriodList, error)
	}

	customXOkrPeriodModel struct {
		*defaultXOkrPeriodModel
	}
)

// NewXOkrPeriodModel returns a model for the database table.
func NewXOkrPeriodModel(conn sqlx.SqlConn) XOkrPeriodModel {
	return &customXOkrPeriodModel{
		defaultXOkrPeriodModel: newXOkrPeriodModel(conn),
	}
}

func (m *customXOkrPeriodModel) withSession(session sqlx.Session) XOkrPeriodModel {
	return NewXOkrPeriodModel(sqlx.NewSqlConnFromSession(session))
}
