// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package okr

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOkrPeriodFieldNames          = builder.RawFieldNames(&XOkrPeriod{})
	xOkrPeriodRows                = strings.Join(xOkrPeriodFieldNames, ",")
	xOkrPeriodRowsExpectAutoSet   = strings.Join(stringx.Remove(xOkrPeriodFieldNames, "`period_id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOkrPeriodRowsWithPlaceHolder = strings.Join(stringx.Remove(xOkrPeriodFieldNames, "`period_id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOkrPeriodModel interface {
		Insert(ctx context.Context, data *XOkrPeriod) (sql.Result, error)
		FindOne(ctx context.Context, periodId int64) (*XOkrPeriod, error)
		FindOneByOwnerStartDateEndDate(ctx context.Context, owner string, startDate time.Time, endDate time.Time) (*XOkrPeriod, error)
		Update(ctx context.Context, data *XOkrPeriod) error
		Delete(ctx context.Context, periodId int64) error
	}

	defaultXOkrPeriodModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOkrPeriod struct {
		PeriodId             int64     `db:"period_id"`              // 周期id
		Owner                string    `db:"owner"`                  // 用户
		StartDate            time.Time `db:"start_date"`             // 周期开始时间
		EndDate              time.Time `db:"end_date"`               // 周期结束时间
		OwnerDepartmentKeys  string    `db:"owner_department_keys"`  // 用户所在部门key列表【纯冗余】
		OwnerDepartmentNames string    `db:"owner_department_names"` // 用户所在部门name列表【纯冗余】
		ApprovalStatus       int64     `db:"approval_status"`        // 确认状态枚举: 1未确认，2待确认，3已确认
		CreatedAt            time.Time `db:"created_at"`             // 创建时间
		UpdatedAt            time.Time `db:"updated_at"`             // 更新时间
	}
)

func newXOkrPeriodModel(conn sqlx.SqlConn) *defaultXOkrPeriodModel {
	return &defaultXOkrPeriodModel{
		conn:  conn,
		table: "`x_okr_period`",
	}
}

func (m *defaultXOkrPeriodModel) Delete(ctx context.Context, periodId int64) error {
	query := fmt.Sprintf("delete from %s where `period_id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, periodId)
	return err
}

func (m *defaultXOkrPeriodModel) FindOne(ctx context.Context, periodId int64) (*XOkrPeriod, error) {
	query := fmt.Sprintf("select %s from %s where `period_id` = ? limit 1", xOkrPeriodRows, m.table)
	var resp XOkrPeriod
	err := m.conn.QueryRowCtx(ctx, &resp, query, periodId)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrPeriodModel) FindOneByOwnerStartDateEndDate(ctx context.Context, owner string, startDate time.Time, endDate time.Time) (*XOkrPeriod, error) {
	var resp XOkrPeriod
	query := fmt.Sprintf("select %s from %s where `owner` = ? and `start_date` = ? and `end_date` = ? limit 1", xOkrPeriodRows, m.table)
	err := m.conn.QueryRowCtx(ctx, &resp, query, owner, startDate, endDate)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOkrPeriodModel) Insert(ctx context.Context, data *XOkrPeriod) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?)", m.table, xOkrPeriodRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.Owner, data.StartDate, data.EndDate, data.OwnerDepartmentKeys, data.OwnerDepartmentNames, data.ApprovalStatus)
	return ret, err
}

func (m *defaultXOkrPeriodModel) Update(ctx context.Context, newData *XOkrPeriod) error {
	query := fmt.Sprintf("update %s set %s where `period_id` = ?", m.table, xOkrPeriodRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, newData.Owner, newData.StartDate, newData.EndDate, newData.OwnerDepartmentKeys, newData.OwnerDepartmentNames, newData.ApprovalStatus, newData.PeriodId)
	return err
}

func (m *defaultXOkrPeriodModel) tableName() string {
	return m.table
}
