package okr

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XOKrTaskModel = (*customXOKrTaskModel)(nil)

type (
	// XOKrTaskModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXOKrTaskModel.
	XOKrTaskModel interface {
		xOKrTaskModel
		withSession(session sqlx.Session) XOKrTaskModel

		GetByPeriod(ctx context.Context, session sqlx.Session, period int64) (list []*XOKrTask, err error)
		GetEntities(ctx context.Context, session sqlx.Session, entityIds []int64) (list []*XOKrTask, err error)
		GetEntityRootPaths(ctx context.Context, session sqlx.Session, entityIds []int64) (list []*XOKrTask, err error)
		BulkUpdatePosition(ctx context.Context, session sqlx.Session, entityIdToPosition map[int64]int64) (sql.Result, error)
		GetChildren(parentID int64) (list []*XOKrTask, err error)
		InsertWithSession(conn sqlx.Session, data *XOKrTask) (sql.Result, error)
		UpdateWithSession(conn sqlx.Session, data *XOKrTask) (sql.Result, error)
		GetByOkrPeriodId(okrPeriodId int64) (list []*XOKrTask, err error)
		GetByOkrPeriodIdAndEntityType(okrPeriodId, entityType int64) (list OKrTaskList, err error)
		GetOneUserOkrEntity(ctx context.Context, periodId, parentEntityId, entityId int64) (*XOKrTask, error)
		FindByUserAndAlignWithEntity(ctx context.Context, owner string, alignWithEntityId int64) (list OKrTaskList, err error)
		GetByParentEntityId(entityId int64) (list OKrTaskList, err error)
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XOKrTask) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XOKrTask) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, entityIds []int64) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
	}

	customXOKrTaskModel struct {
		*defaultXOKrTaskModel
	}
)

// NewXOKrTaskModel returns a model for the database table.
func NewXOKrTaskModel(conn sqlx.SqlConn) XOKrTaskModel {
	return &customXOKrTaskModel{
		defaultXOKrTaskModel: newXOKrTaskModel(conn),
	}
}

func (m *customXOKrTaskModel) withSession(session sqlx.Session) XOKrTaskModel {
	return NewXOKrTaskModel(sqlx.NewSqlConnFromSession(session))
}
