// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package okr

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xOKrTaskFieldNames          = builder.RawFieldNames(&XOKrTask{})
	xOKrTaskRows                = strings.Join(xOKrTaskFieldNames, ",")
	xOKrTaskRowsExpectAutoSet   = strings.Join(stringx.Remove(xOKrTaskFieldNames, "`entity_id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xOKrTaskRowsWithPlaceHolder = strings.Join(stringx.Remove(xOKrTaskFieldNames, "`entity_id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xOKrTaskModel interface {
		Insert(ctx context.Context, data *XOKrTask) (sql.Result, error)
		FindOne(ctx context.Context, entityId int64) (*XOKrTask, error)
		Update(ctx context.Context, data *XOKrTask) error
		Delete(ctx context.Context, entityId int64) error
	}

	defaultXOKrTaskModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XOKrTask struct {
		EntityId       int64     `db:"entity_id"`        // o/kr/task的id
		EntityType     int64     `db:"entity_type"`      // 类型枚举: o1，kr2，task3
		ParentEntityId int64     `db:"parent_entity_id"` // 父节点entity_id
		PeriodId       int64     `db:"period_id"`        // okr周期id
		Content        string    `db:"content"`          // 内容
		Priority       int64     `db:"priority"`         // 优先级
		Deadline       time.Time `db:"deadline"`         // entity截止日期
		TypeForKr      int64     `db:"type_for_kr"`      // kr类型枚举: 1承诺型、2挑战型，默认为承诺型
		Owner          string    `db:"owner"`            // 负责人 【冗余的， 由本记录的period_id决定】
		Position       int64     `db:"position"`         // 在负责人视图中的元素序号
		Weight         float64   `db:"weight"`           // 在负责人视图中的元素权重
		IntendedOwner  string    `db:"intended_owner"`   // 领导尝试将这个条目分配给哪个下属(仅申请未批复时为非空)
		CreatedAt      time.Time `db:"created_at"`       // 创建时间
		UpdatedAt      time.Time `db:"updated_at"`       // 更新时间
	}
)

func newXOKrTaskModel(conn sqlx.SqlConn) *defaultXOKrTaskModel {
	return &defaultXOKrTaskModel{
		conn:  conn,
		table: "`x_o_kr_task`",
	}
}

func (m *defaultXOKrTaskModel) Delete(ctx context.Context, entityId int64) error {
	query := fmt.Sprintf("delete from %s where `entity_id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, entityId)
	return err
}

func (m *defaultXOKrTaskModel) FindOne(ctx context.Context, entityId int64) (*XOKrTask, error) {
	query := fmt.Sprintf("select %s from %s where `entity_id` = ? limit 1", xOKrTaskRows, m.table)
	var resp XOKrTask
	err := m.conn.QueryRowCtx(ctx, &resp, query, entityId)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXOKrTaskModel) Insert(ctx context.Context, data *XOKrTask) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xOKrTaskRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.EntityType, data.ParentEntityId, data.PeriodId, data.Content, data.Priority, data.Deadline, data.TypeForKr, data.Owner, data.Position, data.Weight, data.IntendedOwner)
	return ret, err
}

func (m *defaultXOKrTaskModel) Update(ctx context.Context, data *XOKrTask) error {
	query := fmt.Sprintf("update %s set %s where `entity_id` = ?", m.table, xOKrTaskRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.EntityType, data.ParentEntityId, data.PeriodId, data.Content, data.Priority, data.Deadline, data.TypeForKr, data.Owner, data.Position, data.Weight, data.IntendedOwner, data.EntityId)
	return err
}

func (m *defaultXOKrTaskModel) tableName() string {
	return m.table
}
