package performance

import (
	"context"
	"database/sql"
	"fmt"
	"time"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

func (m *customXPerformanceAdditionModel) XDelete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("update %s set `deleted_at` = ? where `id` = ? %s", m.table, queryBuilder())
	_, err := m.conn.ExecCtx(ctx, query, time.Now(), id)
	return err
}

func (m *customXPerformanceAdditionModel) XFindOne(ctx context.Context, id uint64) (*XPerformanceAddition, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? %s limit 1", xPerformanceAdditionRows, m.table, queryBuilder())
	var resp XPerformanceAddition
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *customXPerformanceAdditionModel) XInsert(ctx context.Context, data *XPerformanceAddition) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceAdditionRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt)
	return ret, err
}

func (m *customXPerformanceAdditionModel) XUpdate(ctx context.Context, data *XPerformanceAddition) error {
	if data.ItemName == "其他部门同事评价" {
		query := fmt.Sprintf("update %s set %s where `id` = ? %s", m.table, xPerformanceAdditionRowsWithPlaceHolderCoworker, queryBuilder())
		_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.CoworkerEmail, data.LeaderScore, data.DeletedAt, data.Id)
		return err
	} else {
		query := fmt.Sprintf("update %s set %s where `id` = ? %s", m.table, xPerformanceAdditionRowsWithPlaceHolder, queryBuilder())
		_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt, data.Id)
		return err
	}
}
func (m *customXPerformanceAdditionModel) UpdatePerformanceAddition(ctx context.Context, req UpdatePerformanceAdditionScoreReq) error {
	query := fmt.Sprintf("update %s set `item_desc` = ?, `self_score` = ? where `id` = ? ", m.table)
	_, err := m.conn.ExecCtx(ctx, query, req.ItemDesc, req.Score, req.ItemId)
	return err
}

// 自定义事务方法
func (m *customXPerformanceAdditionModel) TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAddition) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceAdditionRowsExpectAutoSet)
	ret, err := session.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt)
	return ret, err
}

func (m *customXPerformanceAdditionModel) TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAddition) error {
	query := fmt.Sprintf("update %s set %s where `id` = ? %s", m.table, xPerformanceAdditionRowsWithPlaceHolder, queryBuilder())
	_, err := session.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt, data.Id)
	return err
}

func (m *customXPerformanceAdditionModel) TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error {
	query := fmt.Sprintf("update %s  set deleted_at = ? where `id` = ?", m.table)
	_, err := session.ExecCtx(ctx, query, time.Now(), id)
	return err
}

func (m *customXPerformanceAdditionModel) TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error {
	return m.conn.TransactCtx(ctx, func(ctx context.Context, s sqlx.Session) error {
		return fn(ctx, s)
	})
}

func (m *customXPerformanceAdditionModel) GetAdditionItemsByPerformandId(ctx context.Context, performanceId uint64) (PerformanceAdditionItemList, error) {
	var list PerformanceAdditionItemList
	query := fmt.Sprintf("select * from %s where `performance_id` = ? %s order by `id` asc", m.table, queryBuilder())
	err := m.conn.QueryRowsCtx(ctx, &list, query, performanceId)
	if err != nil {
		return nil, err
	}
	return list, nil
}

func (m *customXPerformanceAdditionModel) TransGetAdditionItemsByPerformandId(ctx context.Context, session sqlx.Session, performanceId uint64) (PerformanceAdditionItemList, error) {
	var list PerformanceAdditionItemList
	query := fmt.Sprintf("select * from %s where `performance_id` = ? %s order by `id` asc", m.table, queryBuilder())
	err := session.QueryRowsCtx(ctx, &list, query, performanceId)
	if err != nil {
		return nil, err
	}
	return list, nil
}

type PerformanceAdditionItemList []*XPerformanceAddition
