package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

func (m *customXPerformanceAdditionScoreModel) XFindOne(ctx context.Context, id uint64) (*XPerformanceAdditionScore, error) {
	query := fmt.Sprintf("select %s from %s where `item_id` = ? limit 1", xPerformanceAdditionScoreRows, m.table)
	var resp XPerformanceAdditionScore
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}
func (m *customXPerformanceAdditionScoreModel) TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAdditionScore) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceAdditionScoreRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.Year, data.Score, data.MonthNum, data.UserEmail, data.Status, data.ItemDesc, data.CoworkerEmail, data.Id)
	return err
}

func (m *customXPerformanceAdditionScoreModel) TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAdditionScore) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceAdditionScoreRowsExpectAutoSet)
	ret, err := session.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.Year, data.Score, data.MonthNum, data.UserEmail, data.Status, data.ItemDesc, data.CoworkerEmail)
	return ret, err
}

func (m *customXPerformanceAdditionScoreModel) TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error {
	return m.conn.TransactCtx(ctx, func(ctx context.Context, s sqlx.Session) error {
		return fn(ctx, s)
	})
}

type PageByPerformanceAdditionScoreReq struct {
	Year          uint64
	PerformanceId uint64
	ItemId        uint64
	UserEmail     string
	MonthNum      uint64
	CoworkerEmail string
	PageNum       uint64
	PageSize      uint64
	OrderBy       string // "updated_at desc"
}
type UpdatePerformanceAdditionScoreReq struct {
	ItemId   uint64
	ItemDesc string
	Score    float64
}

func (m *customXPerformanceAdditionScoreModel) UpdatePerformanceAdditionScore(ctx context.Context, req UpdatePerformanceAdditionScoreReq) error {
	fmt.Println("其他同事开始进行评分接口")
	query := fmt.Sprintf("update %s set `status` = 2,`item_desc` = ?, `score` = ? where `item_id` = ? ", m.table)
	_, err := m.conn.ExecCtx(ctx, query, req.ItemDesc, req.Score, req.ItemId)
	return err
}
func (m *customXPerformanceAdditionScoreModel) PageByPerformanceAdditionScore(ctx context.Context, req PageByPerformanceAdditionScoreReq) (PerformanceAdditionScoreList, uint64, error) {
	//offset := req.PageSize * (req.PageNum - 1)
	//sql := "`coworker_email` = '" + req.CoworkerEmail + "'"
	//if req.UserEmail != "" {
	//	sql += fmt.Sprintf(" and `user_email` = '%s' ", req.UserEmail)
	//}
	//if req.MonthNum != 0 {
	//	sql += fmt.Sprintf(" and `month_num` = %d ", req.MonthNum)
	//}
	//if req.Year != 0 {
	//	sql += fmt.Sprintf(" and `year` = %d ", req.Year)
	//}

	var args []any
	conditions := []string{"`coworker_email` = ?"}
	args = append(args, req.CoworkerEmail)
	if req.Year != 0 {
		conditions = append(conditions, "`year` = ?")
		args = append(args, req.Year)
	}
	if req.MonthNum != 0 {
		conditions = append(conditions, "`month_num` = ?")
		args = append(args, req.MonthNum)
	}
	if req.UserEmail != "" {
		conditions = append(conditions, "`user_email` like ?")
		args = append(args, req.UserEmail+"%")
	}
	query := fmt.Sprintf("select * from %s where %s order by id desc", m.table, strings.Join(conditions, " and "))
	queryCount := fmt.Sprintf("select count(*) as `total` from %s where %s", m.table, strings.Join(conditions, " and ")) //必须写死叫 total
	total := &PerformanceAdditionScoreCountData{}
	err := m.conn.QueryRowPartialCtx(ctx, total, queryCount, args...)
	//fmt.Println("总数", total.Total, err)
	if err != nil {
		return nil, 0, err
	}
	if req.PageNum > 0 && req.PageSize > 0 {
		offset := req.PageSize * (req.PageNum - 1)
		query = fmt.Sprintf("%s limit ? offset ?", query)
		args = append(args, req.PageSize, offset)
	}
	//fmt.Println(query, conditions)

	var list PerformanceAdditionScoreList
	err = m.conn.QueryRowsCtx(ctx, &list, query, args...)
	if err != nil {
		return nil, 0, err
	}
	return list, total.Total, nil
}
func (m *customXPerformanceAdditionScoreModel) ListPerformanceAdditionScore(ctx context.Context, req PageByPerformanceAdditionScoreReq) (PerformanceAdditionScoreList, uint64, error) {
	var args []any
	conditions := []string{"1=1"}
	if req.Year != 0 {
		conditions = append(conditions, "`year` = ?")
		args = append(args, req.Year)
	}
	if req.MonthNum != 0 {
		conditions = append(conditions, "`month_num` = ?")
		args = append(args, req.MonthNum)
	}
	if req.UserEmail != "" {
		conditions = append(conditions, "`user_email` like ?")
		args = append(args, req.UserEmail+"%")
	}
	query := fmt.Sprintf("select * from %s where %s order by id desc", m.table, strings.Join(conditions, " and "))
	queryCount := fmt.Sprintf("select count(*) as `total` from %s where %s", m.table, strings.Join(conditions, " and ")) //必须写死叫 total
	total := &PerformanceAdditionScoreCountData{}
	err := m.conn.QueryRowPartialCtx(ctx, total, queryCount, args...)
	//fmt.Println("总数", total.Total, err)
	if err != nil {
		return nil, 0, err
	}
	if req.PageNum > 0 && req.PageSize > 0 {
		offset := req.PageSize * (req.PageNum - 1)
		query = fmt.Sprintf("%s limit ? offset ?", query)
		args = append(args, req.PageSize, offset)
	}
	//fmt.Println(query, conditions)

	var list PerformanceAdditionScoreList
	err = m.conn.QueryRowsCtx(ctx, &list, query, args...)
	if err != nil {
		return nil, 0, err
	}
	return list, total.Total, nil
}

type PerformanceAdditionScoreList []*XPerformanceAdditionScore
type PerformanceAdditionScoreCountData struct {
	Total uint64 `db:"total"`
}

func (l PerformanceAdditionScoreList) Ids() []uint64 {
	ids := make([]uint64, len(l))
	for i, v := range l {
		ids[i] = v.Id
	}
	return ids
}

//func (l PerformanceItemCommentList) ByItemIdAndCommentType(itemId, commentType uint64) PerformanceItemCommentList {
//	var list PerformanceItemCommentList
//	for _, v := range l {
//		if v.ItemId == itemId && v.CommentType == commentType {
//			list = append(list, v)
//		}
//	}
//	return list
//}
