package performance

import (
	"context"
	"database/sql"

	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPerformanceAdditionModel = (*customXPerformanceAdditionModel)(nil)

type (
	// XPerformanceAdditionModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPerformanceAdditionModel.
	XPerformanceAdditionModel interface {
		xPerformanceAdditionModel
		withSession(session sqlx.Session) XPerformanceAdditionModel

		// 自定义
		XInsert(ctx context.Context, data *XPerformanceAddition) (sql.Result, error)
		XFindOne(ctx context.Context, id uint64) (*XPerformanceAddition, error)
		XUpdate(ctx context.Context, data *XPerformanceAddition) error
		XDelete(ctx context.Context, id uint64) error
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAddition) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAddition) error
		TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error

		GetAdditionItemsByPerformandId(ctx context.Context, performanceId uint64) (PerformanceAdditionItemList, error)
		TransGetAdditionItemsByPerformandId(ctx context.Context, session sqlx.Session, performanceId uint64) (PerformanceAdditionItemList, error)
		UpdatePerformanceAddition(ctx context.Context, req UpdatePerformanceAdditionScoreReq) error
	}

	customXPerformanceAdditionModel struct {
		*defaultXPerformanceAdditionModel
	}
)

// NewXPerformanceAdditionModel returns a model for the database table.
func NewXPerformanceAdditionModel(conn sqlx.SqlConn) XPerformanceAdditionModel {
	return &customXPerformanceAdditionModel{
		defaultXPerformanceAdditionModel: newXPerformanceAdditionModel(conn),
	}
}

func (m *customXPerformanceAdditionModel) withSession(session sqlx.Session) XPerformanceAdditionModel {
	return NewXPerformanceAdditionModel(sqlx.NewSqlConnFromSession(session))
}
