// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.1

package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPerformanceAdditionFieldNames          = builder.RawFieldNames(&XPerformanceAddition{})
	xPerformanceAdditionRows                = strings.Join(xPerformanceAdditionFieldNames, ",")
	xPerformanceAdditionRowsExpectAutoSet   = strings.Join(stringx.Remove(xPerformanceAdditionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPerformanceAdditionRowsWithPlaceHolder = strings.Join(stringx.Remove(xPerformanceAdditionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"

	//xPerformanceAdditionRowsExpectAutoSetCoworker   = strings.Join(stringx.Remove(xPerformanceAdditionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`","`item_desc`","`self_score`"), ",")
	xPerformanceAdditionRowsWithPlaceHolderCoworker = strings.Join(stringx.Remove(xPerformanceAdditionFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`", "`item_desc`", "`self_score`"), "=?,") + "=?"
)

type (
	xPerformanceAdditionModel interface {
		Insert(ctx context.Context, data *XPerformanceAddition) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XPerformanceAddition, error)
		Update(ctx context.Context, data *XPerformanceAddition) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXPerformanceAdditionModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPerformanceAddition struct {
		Id            uint64       `db:"id"`             // 主键ID
		PerformanceId uint64       `db:"performance_id"` // 绩效ID
		ItemName      string       `db:"item_name"`      // 附加项名称
		ItemType      uint64       `db:"item_type"`      // 附加项类型 1：行为及态度指标 2: 管理能力指 3: 附加规则
		ItemWeight    float64      `db:"item_weight"`    // 权重
		ItemDesc      string       `db:"item_desc"`      // 附加项具体描述
		CoworkerEmail string       `db:"coworker_email"` // 其他部门评价人
		SelfScore     float64      `db:"self_score"`     // 自评分
		LeaderScore   float64      `db:"leader_score"`   // 上级评分
		CreatedAt     time.Time    `db:"created_at"`     // 创建时间
		UpdatedAt     time.Time    `db:"updated_at"`     // 更新时间
		DeletedAt     sql.NullTime `db:"deleted_at"`     // 删除时间
	}
)

func newXPerformanceAdditionModel(conn sqlx.SqlConn) *defaultXPerformanceAdditionModel {
	return &defaultXPerformanceAdditionModel{
		conn:  conn,
		table: "`x_performance_addition`",
	}
}

func (m *defaultXPerformanceAdditionModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPerformanceAdditionModel) FindOne(ctx context.Context, id uint64) (*XPerformanceAddition, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPerformanceAdditionRows, m.table)
	var resp XPerformanceAddition
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPerformanceAdditionModel) Insert(ctx context.Context, data *XPerformanceAddition) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceAdditionRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt)
	return ret, err
}

func (m *defaultXPerformanceAdditionModel) Update(ctx context.Context, data *XPerformanceAddition) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceAdditionRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemName, data.ItemType, data.ItemWeight, data.ItemDesc, data.CoworkerEmail, data.SelfScore, data.LeaderScore, data.DeletedAt, data.Id)
	return err
}

func (m *defaultXPerformanceAdditionModel) tableName() string {
	return m.table
}
