package performance

import (
	"context"
	"database/sql"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
)

var _ XPerformanceAdditionScoreModel = (*customXPerformanceAdditionScoreModel)(nil)

type (
	// XPerformanceAdditionScoreModel is an interface to be customized, add more methods here,
	// and implement the added methods in customXPerformanceAdditionScoreModel.
	XPerformanceAdditionScoreModel interface {
		xPerformanceAdditionScoreModel
		withSession(session sqlx.Session) XPerformanceAdditionScoreModel
		TransInsertCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAdditionScore) (sql.Result, error)
		TransUpdateCtx(ctx context.Context, session sqlx.Session, data *XPerformanceAdditionScore) error
		//TransDeleteCtx(ctx context.Context, session sqlx.Session, id uint64) error
		XFindOne(ctx context.Context, id uint64) (*XPerformanceAdditionScore, error)
		TransCtx(ctx context.Context, fn func(ctx context.Context, s sqlx.Session) error) error
		PageByPerformanceAdditionScore(ctx context.Context, req PageByPerformanceAdditionScoreReq) (PerformanceAdditionScoreList, uint64, error)
		ListPerformanceAdditionScore(ctx context.Context, req PageByPerformanceAdditionScoreReq) (PerformanceAdditionScoreList, uint64, error)
		UpdatePerformanceAdditionScore(ctx context.Context, req UpdatePerformanceAdditionScoreReq) error
	}

	customXPerformanceAdditionScoreModel struct {
		*defaultXPerformanceAdditionScoreModel
	}
)

// NewXPerformanceAdditionScoreModel returns a model for the database table.
func NewXPerformanceAdditionScoreModel(conn sqlx.SqlConn) XPerformanceAdditionScoreModel {
	return &customXPerformanceAdditionScoreModel{
		defaultXPerformanceAdditionScoreModel: newXPerformanceAdditionScoreModel(conn),
	}
}

func (m *customXPerformanceAdditionScoreModel) withSession(session sqlx.Session) XPerformanceAdditionScoreModel {
	return NewXPerformanceAdditionScoreModel(sqlx.NewSqlConnFromSession(session))
}
