// Code generated by goctl. DO NOT EDIT.
// versions:
//  goctl version: 1.8.3

package performance

import (
	"context"
	"database/sql"
	"fmt"
	"strings"
	"time"

	"github.com/zeromicro/go-zero/core/stores/builder"
	"github.com/zeromicro/go-zero/core/stores/sqlx"
	"github.com/zeromicro/go-zero/core/stringx"
)

var (
	xPerformanceAdditionScoreFieldNames          = builder.RawFieldNames(&XPerformanceAdditionScore{})
	xPerformanceAdditionScoreRows                = strings.Join(xPerformanceAdditionScoreFieldNames, ",")
	xPerformanceAdditionScoreRowsExpectAutoSet   = strings.Join(stringx.Remove(xPerformanceAdditionScoreFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), ",")
	xPerformanceAdditionScoreRowsWithPlaceHolder = strings.Join(stringx.Remove(xPerformanceAdditionScoreFieldNames, "`id`", "`create_at`", "`create_time`", "`created_at`", "`update_at`", "`update_time`", "`updated_at`"), "=?,") + "=?"
)

type (
	xPerformanceAdditionScoreModel interface {
		Insert(ctx context.Context, data *XPerformanceAdditionScore) (sql.Result, error)
		FindOne(ctx context.Context, id uint64) (*XPerformanceAdditionScore, error)
		Update(ctx context.Context, data *XPerformanceAdditionScore) error
		Delete(ctx context.Context, id uint64) error
	}

	defaultXPerformanceAdditionScoreModel struct {
		conn  sqlx.SqlConn
		table string
	}

	XPerformanceAdditionScore struct {
		Id            uint64    `db:"id"`             // 主键ID
		PerformanceId uint64    `db:"performance_id"` // 绩效ID
		ItemId        int64     `db:"item_id"`        // 项目ID
		Year          uint64    `db:"year"`           // 绩效所属年度
		Score         float64   `db:"score"`          // 其他部门同事的评分
		MonthNum      uint64    `db:"month_num"`      // 双月编号,7:年度绩效,1:第一个双月, 2: 第二双月...
		UserEmail     string    `db:"user_email"`     // 被评价同事姓名
		Status        int64     `db:"status"`         // 状态：1，未评分 2，已提交
		ItemDesc      string    `db:"item_desc"`      // 其他部门同事对当前同事的评价内容
		CoworkerEmail string    `db:"coworker_email"` // 其他部门评价人
		CreatedAt     time.Time `db:"created_at"`     // 创建时间
		UpdatedAt     time.Time `db:"updated_at"`     // 更新时间
	}
)

func newXPerformanceAdditionScoreModel(conn sqlx.SqlConn) *defaultXPerformanceAdditionScoreModel {
	return &defaultXPerformanceAdditionScoreModel{
		conn:  conn,
		table: "`x_performance_addition_score`",
	}
}

func (m *defaultXPerformanceAdditionScoreModel) Delete(ctx context.Context, id uint64) error {
	query := fmt.Sprintf("delete from %s where `id` = ?", m.table)
	_, err := m.conn.ExecCtx(ctx, query, id)
	return err
}

func (m *defaultXPerformanceAdditionScoreModel) FindOne(ctx context.Context, id uint64) (*XPerformanceAdditionScore, error) {
	query := fmt.Sprintf("select %s from %s where `id` = ? limit 1", xPerformanceAdditionScoreRows, m.table)
	var resp XPerformanceAdditionScore
	err := m.conn.QueryRowCtx(ctx, &resp, query, id)
	switch err {
	case nil:
		return &resp, nil
	case sqlx.ErrNotFound:
		return nil, ErrNotFound
	default:
		return nil, err
	}
}

func (m *defaultXPerformanceAdditionScoreModel) Insert(ctx context.Context, data *XPerformanceAdditionScore) (sql.Result, error) {
	query := fmt.Sprintf("insert into %s (%s) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", m.table, xPerformanceAdditionScoreRowsExpectAutoSet)
	ret, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.Year, data.Score, data.MonthNum, data.UserEmail, data.Status, data.ItemDesc, data.CoworkerEmail)
	return ret, err
}

func (m *defaultXPerformanceAdditionScoreModel) Update(ctx context.Context, data *XPerformanceAdditionScore) error {
	query := fmt.Sprintf("update %s set %s where `id` = ?", m.table, xPerformanceAdditionScoreRowsWithPlaceHolder)
	_, err := m.conn.ExecCtx(ctx, query, data.PerformanceId, data.ItemId, data.Year, data.Score, data.MonthNum, data.UserEmail, data.Status, data.ItemDesc, data.CoworkerEmail, data.Id)
	return err
}

func (m *defaultXPerformanceAdditionScoreModel) tableName() string {
	return m.table
}
